/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.io;

import java.io.IOException;
import java.io.OutputStream;

public abstract class LineOutputStream
extends OutputStream {
    private int bufferSize = 1024;
    private char[] buffer;
    private StringBuffer line = new StringBuffer();
    private int bufferCount = 0;

    public LineOutputStream() {
        this(1024);
    }

    public LineOutputStream(int bufferSize) {
        this.bufferSize = bufferSize;
        this.buffer = new char[bufferSize];
    }

    @Override
    public final void write(int b) throws IOException {
        if (b == 10) {
            this.line.append(this.buffer);
            this.writeLine(this.line.toString().replaceAll("\\r|\\n", ""));
            this.line = new StringBuffer();
            this.bufferCount = 0;
            this.buffer = new char[this.bufferSize];
            return;
        }
        if (this.bufferCount < this.bufferSize) {
            this.buffer[this.bufferCount++] = (char)b;
            return;
        }
        this.line.append(this.buffer);
        this.bufferCount = 0;
        this.buffer = new char[this.bufferSize];
    }

    public abstract void writeLine(String var1) throws IOException;
}

